package ONVIF::Media::Types::Capabilities;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/media/wsdl' };

our $XML_ATTRIBUTE_CLASS = 'ONVIF::Media::Types::Capabilities::_Capabilities::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ProfileCapabilities_of :ATTR(:get<ProfileCapabilities>);
my %StreamingCapabilities_of :ATTR(:get<StreamingCapabilities>);

__PACKAGE__->_factory(
    [ qw(        ProfileCapabilities
        StreamingCapabilities

    ) ],
    {
        'ProfileCapabilities' => \%ProfileCapabilities_of,
        'StreamingCapabilities' => \%StreamingCapabilities_of,
    },
    {
        'ProfileCapabilities' => 'ONVIF::Media::Types::ProfileCapabilities',
        'StreamingCapabilities' => 'ONVIF::Media::Types::StreamingCapabilities',
    },
    {

        'ProfileCapabilities' => 'ProfileCapabilities',
        'StreamingCapabilities' => 'StreamingCapabilities',
    }
);

} # end BLOCK




package ONVIF::Media::Types::Capabilities::_Capabilities::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %SnapshotUri_of :ATTR(:get<SnapshotUri>);
my %Rotation_of :ATTR(:get<Rotation>);
my %VideoSourceMode_of :ATTR(:get<VideoSourceMode>);
my %OSD_of :ATTR(:get<OSD>);

__PACKAGE__->_factory(
    [ qw(
        SnapshotUri
        Rotation
        VideoSourceMode
        OSD
    ) ],
    {

        SnapshotUri => \%SnapshotUri_of,

        Rotation => \%Rotation_of,

        VideoSourceMode => \%VideoSourceMode_of,

        OSD => \%OSD_of,
    },
    {
        SnapshotUri => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        Rotation => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        VideoSourceMode => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        OSD => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

ONVIF::Media::Types::Capabilities

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Capabilities from the namespace http://www.onvif.org/ver10/media/wsdl.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ProfileCapabilities


=item * StreamingCapabilities




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::Capabilities
   ProfileCapabilities =>  { # ONVIF::Media::Types::ProfileCapabilities
   },
   StreamingCapabilities =>  { # ONVIF::Media::Types::StreamingCapabilities
   },
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ONVIF::Media::Types::Capabilities::_Capabilities::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * SnapshotUri

 Indicates if GetSnapshotUri is supported.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.

=item * Rotation

 Indicates whether or not Rotation feature is supported.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.

=item * VideoSourceMode

 Indicates the support for changing video source mode.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.

=item * OSD

 Indicates if OSD is supported.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

