package WSNotification::Types::TopicType;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'http://docs.oasis-open.org/wsn/t-1' };

our $XML_ATTRIBUTE_CLASS = 'WSNotification::Types::TopicType::_TopicType::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(WSNotification::Types::ExtensibleDocumented);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %documentation_of :ATTR(:get<documentation>);
my %MessagePattern_of :ATTR(:get<MessagePattern>);

__PACKAGE__->_factory(
    [ qw(        documentation
        MessagePattern

    ) ],
    {
        'documentation' => \%documentation_of,
        'MessagePattern' => \%MessagePattern_of,
    },
    {
        'documentation' => 'WSNotification::Types::Documentation',
        'MessagePattern' => 'WSNotification::Types::QueryExpressionType',
    },
    {

        'documentation' => 'documentation',
        'MessagePattern' => 'MessagePattern',
    }
);

} # end BLOCK




package WSNotification::Types::TopicType::_TopicType::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %name_of :ATTR(:get<name>);
my %final_of :ATTR(:get<final>);

__PACKAGE__->_factory(
    [ qw(
        name
        final
    ) ],
    {

        name => \%name_of,

        final => \%final_of,
    },
    {
        name => 'SOAP::WSDL::XSD::Typelib::Builtin::NCName',
        final => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

WSNotification::Types::TopicType

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TopicType from the namespace http://docs.oasis-open.org/wsn/t-1.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * MessagePattern




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # WSNotification::Types::TopicType
   MessagePattern =>  { # WSNotification::Types::QueryExpressionType
   },
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class WSNotification::Types::TopicType::_TopicType::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * name



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::NCName|SOAP::WSDL::XSD::Typelib::Builtin::NCName>.

=item * final



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

