package ONVIF::Analytics::Types::NetworkHost;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Type_of :ATTR(:get<Type>);
my %IPv4Address_of :ATTR(:get<IPv4Address>);
my %IPv6Address_of :ATTR(:get<IPv6Address>);
my %DNSname_of :ATTR(:get<DNSname>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Type
        IPv4Address
        IPv6Address
        DNSname
        Extension

    ) ],
    {
        'Type' => \%Type_of,
        'IPv4Address' => \%IPv4Address_of,
        'IPv6Address' => \%IPv6Address_of,
        'DNSname' => \%DNSname_of,
        'Extension' => \%Extension_of,
    },
    {
        'Type' => 'ONVIF::Analytics::Types::NetworkHostType',
        'IPv4Address' => 'ONVIF::Analytics::Types::IPv4Address',
        'IPv6Address' => 'ONVIF::Analytics::Types::IPv6Address',
        'DNSname' => 'ONVIF::Analytics::Types::DNSName',
        'Extension' => 'ONVIF::Analytics::Types::NetworkHostExtension',
    },
    {

        'Type' => 'Type',
        'IPv4Address' => 'IPv4Address',
        'IPv6Address' => 'IPv6Address',
        'DNSname' => 'DNSname',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::NetworkHost

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
NetworkHost from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Type


=item * IPv4Address


=item * IPv6Address


=item * DNSname


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::NetworkHost
   Type => $some_value, # NetworkHostType
   IPv4Address => $some_value, # IPv4Address
   IPv6Address => $some_value, # IPv6Address
   DNSname => $some_value, # DNSName
   Extension =>  { # ONVIF::Analytics::Types::NetworkHostExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

