package ONVIF::PTZ::Types::Scope;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ScopeDef_of :ATTR(:get<ScopeDef>);
my %ScopeItem_of :ATTR(:get<ScopeItem>);

__PACKAGE__->_factory(
    [ qw(        ScopeDef
        ScopeItem

    ) ],
    {
        'ScopeDef' => \%ScopeDef_of,
        'ScopeItem' => \%ScopeItem_of,
    },
    {
        'ScopeDef' => 'ONVIF::PTZ::Types::ScopeDefinition',
        'ScopeItem' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
    },
    {

        'ScopeDef' => 'ScopeDef',
        'ScopeItem' => 'ScopeItem',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::Scope

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Scope from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ScopeDef


=item * ScopeItem




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::Scope
   ScopeDef => $some_value, # ScopeDefinition
   ScopeItem =>  $some_value, # anyURI
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

