package ONVIF::Analytics::Types::IPv4NetworkInterface;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Enabled_of :ATTR(:get<Enabled>);
my %Config_of :ATTR(:get<Config>);

__PACKAGE__->_factory(
    [ qw(        Enabled
        Config

    ) ],
    {
        'Enabled' => \%Enabled_of,
        'Config' => \%Config_of,
    },
    {
        'Enabled' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Config' => 'ONVIF::Analytics::Types::IPv4Configuration',
    },
    {

        'Enabled' => 'Enabled',
        'Config' => 'Config',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::IPv4NetworkInterface

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
IPv4NetworkInterface from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Enabled


=item * Config




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::IPv4NetworkInterface
   Enabled =>  $some_value, # boolean
   Config =>  { # ONVIF::Analytics::Types::IPv4Configuration
     Manual =>  { # ONVIF::Analytics::Types::PrefixedIPv4Address
       Address => $some_value, # IPv4Address
       PrefixLength =>  $some_value, # int
     },
     LinkLocal =>  { # ONVIF::Analytics::Types::PrefixedIPv4Address
       Address => $some_value, # IPv4Address
       PrefixLength =>  $some_value, # int
     },
     FromDHCP =>  { # ONVIF::Analytics::Types::PrefixedIPv4Address
       Address => $some_value, # IPv4Address
       PrefixLength =>  $some_value, # int
     },
     DHCP =>  $some_value, # boolean
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

