
package WSNotification::Attributes::base;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.w3.org/XML/1998/namespace' }

__PACKAGE__->__set_name('base');
__PACKAGE__->__set_ref();
use base qw(
    SOAP::WSDL::XSD::Typelib::Attribute
    SOAP::WSDL::XSD::Typelib::Builtin::anyURI
);

}

1;


=pod

=head1 NAME

WSNotification::Attributes::base

=head1 DESCRIPTION

Perl data type class for the XML Schema defined attribute
base from the namespace http://www.w3.org/XML/1998/namespace.

http://www.w3.org/TR/xmlbase/ for information about this attribute. 





=head1 METHODS

=head2 new

 my $element = WSNotification::Attributes::base->new($data);

Constructor. The following data structure may be passed to new():

 { value => $value }

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

