package ONVIF::Device::Types::AnalyticsEngine;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::Device::Types::ConfigurationEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %UseCount_of :ATTR(:get<UseCount>);
my %AnalyticsEngineConfiguration_of :ATTR(:get<AnalyticsEngineConfiguration>);

__PACKAGE__->_factory(
    [ qw(        Name
        UseCount
        AnalyticsEngineConfiguration

    ) ],
    {
        'Name' => \%Name_of,
        'UseCount' => \%UseCount_of,
        'AnalyticsEngineConfiguration' => \%AnalyticsEngineConfiguration_of,
    },
    {
        'Name' => 'ONVIF::Device::Types::Name',
        'UseCount' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'AnalyticsEngineConfiguration' => 'ONVIF::Device::Types::AnalyticsDeviceEngineConfiguration',
    },
    {

        'Name' => 'Name',
        'UseCount' => 'UseCount',
        'AnalyticsEngineConfiguration' => 'AnalyticsEngineConfiguration',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::AnalyticsEngine

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AnalyticsEngine from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * AnalyticsEngineConfiguration




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::AnalyticsEngine
   AnalyticsEngineConfiguration =>  { # ONVIF::Device::Types::AnalyticsDeviceEngineConfiguration
     EngineConfiguration =>  { # ONVIF::Device::Types::EngineConfiguration
       VideoAnalyticsConfiguration =>  { # ONVIF::Device::Types::VideoAnalyticsConfiguration
         AnalyticsEngineConfiguration =>  { # ONVIF::Device::Types::AnalyticsEngineConfiguration
           AnalyticsModule =>  { # ONVIF::Device::Types::Config
             Parameters =>  { # ONVIF::Device::Types::ItemList
               SimpleItem => ,
               ElementItem =>  {
               },
               Extension =>  { # ONVIF::Device::Types::ItemListExtension
               },
             },
           },
           Extension =>  { # ONVIF::Device::Types::AnalyticsEngineConfigurationExtension
           },
         },
         RuleEngineConfiguration =>  { # ONVIF::Device::Types::RuleEngineConfiguration
           Rule =>  { # ONVIF::Device::Types::Config
             Parameters =>  { # ONVIF::Device::Types::ItemList
               SimpleItem => ,
               ElementItem =>  {
               },
               Extension =>  { # ONVIF::Device::Types::ItemListExtension
               },
             },
           },
           Extension =>  { # ONVIF::Device::Types::RuleEngineConfigurationExtension
           },
         },
       },
       AnalyticsEngineInputInfo =>  { # ONVIF::Device::Types::AnalyticsEngineInputInfo
         InputInfo =>  { # ONVIF::Device::Types::Config
           Parameters =>  { # ONVIF::Device::Types::ItemList
             SimpleItem => ,
             ElementItem =>  {
             },
             Extension =>  { # ONVIF::Device::Types::ItemListExtension
             },
           },
         },
         Extension =>  { # ONVIF::Device::Types::AnalyticsEngineInputInfoExtension
         },
       },
     },
     Extension =>  { # ONVIF::Device::Types::AnalyticsDeviceEngineConfigurationExtension
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

