
package WSNotification::Elements::SubscriptionManagerRP;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://docs.oasis-open.org/wsn/b-2' }

__PACKAGE__->__set_name('SubscriptionManagerRP');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ConsumerReference_of :ATTR(:get<ConsumerReference>);
my %Filter_of :ATTR(:get<Filter>);
my %SubscriptionPolicy_of :ATTR(:get<SubscriptionPolicy>);
my %CreationTime_of :ATTR(:get<CreationTime>);

__PACKAGE__->_factory(
    [ qw(        ConsumerReference
        Filter
        SubscriptionPolicy
        CreationTime

    ) ],
    {
        'ConsumerReference' => \%ConsumerReference_of,
        'Filter' => \%Filter_of,
        'SubscriptionPolicy' => \%SubscriptionPolicy_of,
        'CreationTime' => \%CreationTime_of,
    },
    {
        'ConsumerReference' => 'WSNotification::Elements::ConsumerReference',

        'Filter' => 'WSNotification::Elements::Filter',

        'SubscriptionPolicy' => 'WSNotification::Elements::SubscriptionPolicy',

        'CreationTime' => 'WSNotification::Elements::CreationTime',

    },
    {

        'ConsumerReference' => '',
        'Filter' => '',
        'SubscriptionPolicy' => '',
        'CreationTime' => '',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

WSNotification::Elements::SubscriptionManagerRP

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SubscriptionManagerRP from the namespace http://docs.oasis-open.org/wsn/b-2.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ConsumerReference

 $element->set_ConsumerReference($data);
 $element->get_ConsumerReference();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 



=item * Filter

 $element->set_Filter($data);
 $element->get_Filter();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 



=item * SubscriptionPolicy

 $element->set_SubscriptionPolicy($data);
 $element->get_SubscriptionPolicy();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 



=item * CreationTime

 $element->set_CreationTime($data);
 $element->get_CreationTime();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 




=back


=head1 METHODS

=head2 new

 my $element = WSNotification::Elements::SubscriptionManagerRP->new($data);

Constructor. The following data structure may be passed to new():

 {
   ConsumerReference =>  { # WSNotification::Types::EndpointReferenceType
     Address =>  { value => $some_value },
     ReferenceParameters =>  { # WSNotification::Types::ReferenceParametersType
     },
     Metadata =>  { # WSNotification::Types::MetadataType
     },
   },
   Filter =>  { # WSNotification::Types::FilterType
     TopicExpression =>  { # WSNotification::Types::TopicExpressionType
     },
     MessageContent =>  { # WSNotification::Types::QueryExpressionType
     },
   },
   SubscriptionPolicy =>  { # WSNotification::Types::SubscriptionPolicyType
   },
   CreationTime =>  $some_value, # dateTime
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

