set(HOST_OS "")
if(${CMAKE_SYSTEM_NAME} STREQUAL "Linux")
  set(HOST_OS "linux")
endif()
if(${CMAKE_SYSTEM_NAME} MATCHES ".*(SunOS|Solaris).*")
  set(HOST_OS "solaris")
  set(SOLARIS 1)
endif()
if(${CMAKE_SYSTEM_NAME} MATCHES ".*BSD.*")
  set(HOST_OS "BSD")
  set(BSD 1)
endif()
if(${CMAKE_SYSTEM_NAME} STREQUAL "Darwin")
  set(HOST_OS "darwin")
endif()
if(NOT HOST_OS)
  message(FATAL_ERROR
    "ZoneMinder was unable to determine the host OS. Please report this.
    Value of CMAKE_SYSTEM_NAME: ${CMAKE_SYSTEM_NAME}")
endif()

if(CMAKE_SYSTEM_NAME MATCHES "Linux")
  string(TOLOWER "${CMAKE_SYSTEM_PROCESSOR}" ZM_SYSTEM_PROC)
  if((ZM_SYSTEM_PROC STREQUAL "") OR (ZM_SYSTEM_PROC STREQUAL "unknown"))
    execute_process(COMMAND uname -m OUTPUT_VARIABLE ZM_SYSTEM_PROC ERROR_VARIABLE ZM_SYSTEM_PROC_ERR)

    # maybe make the following error checks fatal
    if(ZM_SYSTEM_PROC_ERR)
      message(WARNING "\nAn error occurred while attempting to determine the system processor:\n${ZM_SYSTEM_PROC_ERR}")
    endif()
    if(NOT ZM_SYSTEM_PROC)
      message(WARNING "\nUnable to determine the system processor. This may cause a build failure.\n")
    endif()
  endif()
endif()

message(STATUS "Detected compiler: ${CMAKE_C_COMPILER}")
if(CMAKE_C_COMPILER MATCHES "gcc" OR CMAKE_C_COMPILER_ID STREQUAL "GNU")
  include(${CMAKE_SOURCE_DIR}/cmake/compiler/gcc/settings.cmake)
elseif(CMAKE_C_COMPILER MATCHES "clang" OR CMAKE_C_COMPILER_ID MATCHES "Clang")
  include(${CMAKE_SOURCE_DIR}/cmake/compiler/clang/settings.cmake)
else()
  message(FATAL_ERROR "No supported compiler found")
endif()
