package WSDiscovery10::Interfaces::WSDiscovery::WSDiscoveryPort;
use strict;
use warnings;
use Class::Std::Fast::Storable;
use Scalar::Util qw(blessed);
use base qw(SOAP::WSDL::Client::Base);

# only load if it hasn't been loaded before
require WSDiscovery10::Typemaps::WSDiscovery
    if not WSDiscovery10::Typemaps::WSDiscovery->can('get_class');

sub START {
    $_[0]->set_proxy('soap.udp://239.255.255.250:3702/') if not $_[2]->{proxy};
    $_[0]->set_class_resolver('WSDiscovery10::Typemaps::WSDiscovery')
        if not $_[2]->{class_resolver};

    $_[0]->set_prefix($_[2]->{use_prefix}) if exists $_[2]->{use_prefix};
}

sub ProbeOp {
    my ($self, $body, $header) = @_;
    die "ProbeOp must be called as object method (\$self is <$self>)" if not blessed($self);
    return $self->SUPER::call({
        operation => 'ProbeOp',
        soap_action => 'http://schemas.xmlsoap.org/ws/2005/04/discovery/Probe',
        style => 'document',
        body => {
            

           'use'            => 'literal',
            namespace       => 'http://schemas.xmlsoap.org/wsdl/soap/',
            encodingStyle   => '',
            parts           =>  [qw( WSDiscovery10::Elements::Probe )],

        },
        header => {
            'use'           => 'literal',
            namespace       => 'http://schemas.xmlsoap.org/ws/2004/08/addressing',
            encodingStyle   => '',
            parts           => [qw( WSDiscovery10::Elements::Header )],
 
        },
        headerfault => {
            
        }
    }, $body, $header);
}




1;



__END__

=pod

=head1 NAME

WSDiscovery10::Interfaces::WSDiscovery::WSDiscoveryPort - SOAP Interface for the WSDiscovery Web Service

=head1 SYNOPSIS

 use WSDiscovery10::Interfaces::WSDiscovery::WSDiscoveryPort;
 my $interface = WSDiscovery10::Interfaces::WSDiscovery::WSDiscoveryPort->new();

 my $response;
 $response = $interface->ProbeOp();



=head1 DESCRIPTION

SOAP Interface for the WSDiscovery web service
located at soap.udp://239.255.255.250:3702/.

=head1 SERVICE WSDiscovery



=head2 Port WSDiscoveryPort



=head1 METHODS

=head2 General methods

=head3 new

Constructor.

All arguments are forwarded to L<SOAP::WSDL::Client|SOAP::WSDL::Client>.

=head2 SOAP Service methods

Method synopsis is displayed with hash refs as parameters.

The commented class names in the method's parameters denote that objects
of the corresponding class can be passed instead of the marked hash ref.

You may pass any combination of objects, hash and list refs to these
methods, as long as you meet the structure.

List items (i.e. multiple occurrences) are not displayed in the synopsis.
You may generally pass a list ref of hash refs (or objects) instead of a hash
ref - this may result in invalid XML if used improperly, though. Note that
SOAP::WSDL always expects list references at maximum depth position.

XML attributes are not displayed in this synopsis and cannot be set using
hash refs. See the respective class' documentation for additional information.



=head3 ProbeOp



Returns a L<WSDiscovery10::Elements::ProbeMatches|WSDiscovery10::Elements::ProbeMatches> object.

 $response = $interface->ProbeOp( { # WSDiscovery10::Types::ProbeType
    Types => $some_value, # QNameListType
    Scopes =>  { value => $some_value },
  },,
 );



=head1 AUTHOR

Generated by SOAP::WSDL on Sat Mar 19 18:11:58 2016

=cut
