
package WSNotification::Elements::Notify;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://docs.oasis-open.org/wsn/b-2' }

__PACKAGE__->__set_name('Notify');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %NotificationMessage_of :ATTR(:get<NotificationMessage>);

__PACKAGE__->_factory(
    [ qw(        NotificationMessage

    ) ],
    {
        'NotificationMessage' => \%NotificationMessage_of,
    },
    {
        'NotificationMessage' => 'WSNotification::Elements::NotificationMessage',

    },
    {

        'NotificationMessage' => '',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

WSNotification::Elements::Notify

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
Notify from the namespace http://docs.oasis-open.org/wsn/b-2.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * NotificationMessage

 $element->set_NotificationMessage($data);
 $element->get_NotificationMessage();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 




=back


=head1 METHODS

=head2 new

 my $element = WSNotification::Elements::Notify->new($data);

Constructor. The following data structure may be passed to new():

 {
   NotificationMessage =>  { # WSNotification::Types::NotificationMessageHolderType
     SubscriptionReference =>  { # WSNotification::Types::EndpointReferenceType
       Address =>  { value => $some_value },
       ReferenceParameters =>  { # WSNotification::Types::ReferenceParametersType
       },
       Metadata =>  { # WSNotification::Types::MetadataType
       },
     },
     Topic =>  { # WSNotification::Types::TopicExpressionType
     },
     ProducerReference =>  { # WSNotification::Types::EndpointReferenceType
       Address =>  { value => $some_value },
       ReferenceParameters =>  { # WSNotification::Types::ReferenceParametersType
       },
       Metadata =>  { # WSNotification::Types::MetadataType
       },
     },
     Message =>  {
     },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

