package ONVIF::Media::Types::SourceReference;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS = 'ONVIF::Media::Types::SourceReference::_SourceReference::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Token_of :ATTR(:get<Token>);

__PACKAGE__->_factory(
    [ qw(        Token

    ) ],
    {
        'Token' => \%Token_of,
    },
    {
        'Token' => 'ONVIF::Media::Types::ReferenceToken',
    },
    {

        'Token' => 'Token',
    }
);

} # end BLOCK




package ONVIF::Media::Types::SourceReference::_SourceReference::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %Type_of :ATTR(:get<Type>);

__PACKAGE__->_factory(
    [ qw(
        Type
    ) ],
    {

        Type => \%Type_of,
    },
    {
        Type => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

ONVIF::Media::Types::SourceReference

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
SourceReference from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Token




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::SourceReference
   Token => $some_value, # ReferenceToken
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ONVIF::Media::Types::SourceReference::_SourceReference::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * Type



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::anyURI|SOAP::WSDL::XSD::Typelib::Builtin::anyURI>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

