package ONVIF::Analytics::Types::CertificateInformation;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %CertificateID_of :ATTR(:get<CertificateID>);
my %IssuerDN_of :ATTR(:get<IssuerDN>);
my %SubjectDN_of :ATTR(:get<SubjectDN>);
my %KeyUsage_of :ATTR(:get<KeyUsage>);
my %ExtendedKeyUsage_of :ATTR(:get<ExtendedKeyUsage>);
my %KeyLength_of :ATTR(:get<KeyLength>);
my %Version_of :ATTR(:get<Version>);
my %SerialNum_of :ATTR(:get<SerialNum>);
my %SignatureAlgorithm_of :ATTR(:get<SignatureAlgorithm>);
my %Validity_of :ATTR(:get<Validity>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        CertificateID
        IssuerDN
        SubjectDN
        KeyUsage
        ExtendedKeyUsage
        KeyLength
        Version
        SerialNum
        SignatureAlgorithm
        Validity
        Extension

    ) ],
    {
        'CertificateID' => \%CertificateID_of,
        'IssuerDN' => \%IssuerDN_of,
        'SubjectDN' => \%SubjectDN_of,
        'KeyUsage' => \%KeyUsage_of,
        'ExtendedKeyUsage' => \%ExtendedKeyUsage_of,
        'KeyLength' => \%KeyLength_of,
        'Version' => \%Version_of,
        'SerialNum' => \%SerialNum_of,
        'SignatureAlgorithm' => \%SignatureAlgorithm_of,
        'Validity' => \%Validity_of,
        'Extension' => \%Extension_of,
    },
    {
        'CertificateID' => 'SOAP::WSDL::XSD::Typelib::Builtin::token',
        'IssuerDN' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'SubjectDN' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'KeyUsage' => 'ONVIF::Analytics::Types::CertificateUsage',
        'ExtendedKeyUsage' => 'ONVIF::Analytics::Types::CertificateUsage',
        'KeyLength' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'Version' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'SerialNum' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'SignatureAlgorithm' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Validity' => 'ONVIF::Analytics::Types::DateTimeRange',
        'Extension' => 'ONVIF::Analytics::Types::CertificateInformationExtension',
    },
    {

        'CertificateID' => 'CertificateID',
        'IssuerDN' => 'IssuerDN',
        'SubjectDN' => 'SubjectDN',
        'KeyUsage' => 'KeyUsage',
        'ExtendedKeyUsage' => 'ExtendedKeyUsage',
        'KeyLength' => 'KeyLength',
        'Version' => 'Version',
        'SerialNum' => 'SerialNum',
        'SignatureAlgorithm' => 'SignatureAlgorithm',
        'Validity' => 'Validity',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::CertificateInformation

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CertificateInformation from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * CertificateID


=item * IssuerDN


=item * SubjectDN


=item * KeyUsage


=item * ExtendedKeyUsage


=item * KeyLength


=item * Version


=item * SerialNum


=item * SignatureAlgorithm


=item * Validity


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::CertificateInformation
   CertificateID =>  $some_value, # token
   IssuerDN =>  $some_value, # string
   SubjectDN =>  $some_value, # string
   KeyUsage =>  { value => $some_value },
   ExtendedKeyUsage =>  { value => $some_value },
   KeyLength =>  $some_value, # int
   Version =>  $some_value, # string
   SerialNum =>  $some_value, # string
   SignatureAlgorithm =>  $some_value, # string
   Validity =>  { # ONVIF::Analytics::Types::DateTimeRange
     From =>  $some_value, # dateTime
     Until =>  $some_value, # dateTime
   },
   Extension =>  { # ONVIF::Analytics::Types::CertificateInformationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

