<?php
App::uses('AppController', 'Controller');
/**
 * GPSReadings Controller
 *
 * @property GPSReading $GPSReading
 */
class GPSReadingsController extends AppController {

  /**
   * Components
   *      
   * @var array
   */     
  public $components = array('RequestHandler');

  public function beforeFilter() {
    parent::beforeFilter();

    global $user;
    $canView = (!$user) || ($user->Monitors() != 'None');
    if (!$canView) {
      throw new UnauthorizedException(__('Insufficient Privileges'));
      return;
    }
  }

  public function index() {
    $this->GPSReading->recursive = -1;

    $named_params = $this->request->params['named'];
    if ( $named_params ) {
      $this->FilterComponent = $this->Components->load('Filter');
      $conditions = $this->FilterComponent->buildFilter($named_params);
    } else {
      $conditions = array();
    }
    $options = ['conditions'=>&$conditions];

    /*
    global $user;
    $allowedMonitors = $user ? preg_split('@,@', $user->MonitorIds(),NULL, PREG_SPLIT_NO_EMPTY) : null;
    if ( $allowedMonitors ) {
      $mon_options = array('GPSReadings.MonitorId' => $allowedMonitors);
    } else {
      $mon_options = '';
    }
     */
    $gpsreadings = $this->GPSReading->find('all', $options);
    $this->set(array(
      'gpsreadings' => $gpsreadings,
      '_serialize' => array('gpsreadings')
    ));
  }

  /**
   * add method
   *
   * @return void
   */
  public function add() {

    if ( !$this->request->is('post') ) {
      throw new BadRequestException(__('Invalid method. Should be post'));
      return;
    }

    global $user;
    $canEdit = (!$user) || $user->Monitors() == 'Edit';
    if ( !$canEdit ) {
      throw new UnauthorizedException(__('Insufficient Privileges'));
      return;
    }

    $gpsreading = null;

    $this->GPSReading->create();
    $gpsreading = $this->GPSReading->save($this->request->data);
    if ( $gpsreading ) {
      $message = 'Saved';
      //$gpsreading = $this->GPSReading->find('first', array('conditions' => array( array('GPSReading.' . $this->GPSReading->primaryKey => $this->GPSReading),
    } else {
      $message = 'Error: ';
      // if there is a validation message, use it
      if ( !$this->GPSReading->validates() ) {
        $message = $this->GPSReading->validationErrors;
      }
    }

    $this->set(array(
      'message' => $message,
      'gpsreading' => $gpsreading,
      '_serialize' => array('message','gpsreading')
    ));
  } // end function add()

  /**
   * edit method
   *
   * @throws NotFoundException
   * @param string $id
   * @return void
   */
  public function edit($id = null) {
    $this->GPSReading->id = $id;

    if ( !$this->GPSReading->exists($id) ) {
      throw new NotFoundException(__('Invalid gpsreading'));
    }
    $message = '';
    if ( $this->request->is(array('post', 'put')) ) {
      global $user;
      $canEdit = (!$user) || $user->Monitors() == 'Edit';
      if ( !$canEdit ) {
        throw new UnauthorizedException(__('Insufficient Privileges'));
        return;
      }
      if ( $this->GPSReading->save($this->request->data) ) {
        $message = 'The gpsreading has been saved.';
      } else {
        $message = 'Error ' . print_r($this->GPSReading->invalidFields());
      }
    }
    $this->set(array(
      'message' => $message,
      '_serialize' => array('message')
    ));
  }

  /**
   * delete method
   *
   * @throws NotFoundException
   * @param string $id
   * @return void
   */
  public function delete($id = null) {
    $this->GPSReading->id = $id;
    if ( !$this->GPSReading->exists() ) {
      throw new NotFoundException(__('Invalid gpsreading'));
    }
    $this->request->allowMethod('post', 'delete');
    global $user;
    $canEdit = (!$user) || $user->Monitors() == 'Edit';
    if ( !$canEdit ) {
      throw new UnauthorizedException(__('Insufficient Privileges'));
      return;
    }
    if ( $this->GPSReading->delete() ) {
      return $this->flash(__('The gpsreading has been deleted.'), array('action' => 'index'));
    } else {
      return $this->flash(__('The gpsreading could not be deleted. Please, try again.'), array('action' => 'index'));
    }
  }
} // end class
