<?php

namespace Microsoft\Graph\Generated\Models;

use Microsoft\Kiota\Abstractions\Serialization\AdditionalDataHolder;
use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;
use Microsoft\Kiota\Abstractions\Store\BackedModel;
use Microsoft\Kiota\Abstractions\Store\BackingStore;
use Microsoft\Kiota\Abstractions\Store\BackingStoreFactorySingleton;

class ChannelSummary implements AdditionalDataHolder, BackedModel, Parsable 
{
    /**
     * @var BackingStore $backingStore Stores model information.
    */
    private BackingStore $backingStore;
    
    /**
     * Instantiates a new channelSummary and sets the default values.
    */
    public function __construct() {
        $this->backingStore = BackingStoreFactorySingleton::getInstance()->createBackingStore();
        $this->setAdditionalData([]);
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return ChannelSummary
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): ChannelSummary {
        return new ChannelSummary();
    }

    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return array<string, mixed>|null
    */
    public function getAdditionalData(): ?array {
        $val = $this->getBackingStore()->get('additionalData');
        if (is_null($val) || is_array($val)) {
            /** @var array<string, mixed>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'additionalData'");
    }

    /**
     * Gets the BackingStore property value. Stores model information.
     * @return BackingStore
    */
    public function getBackingStore(): BackingStore {
        return $this->backingStore;
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return  [
            'guestsCount' => fn(ParseNode $n) => $o->setGuestsCount($n->getIntegerValue()),
            'hasMembersFromOtherTenants' => fn(ParseNode $n) => $o->setHasMembersFromOtherTenants($n->getBooleanValue()),
            'membersCount' => fn(ParseNode $n) => $o->setMembersCount($n->getIntegerValue()),
            '@odata.type' => fn(ParseNode $n) => $o->setOdataType($n->getStringValue()),
            'ownersCount' => fn(ParseNode $n) => $o->setOwnersCount($n->getIntegerValue()),
        ];
    }

    /**
     * Gets the guestsCount property value. Count of guests in a channel.
     * @return int|null
    */
    public function getGuestsCount(): ?int {
        $val = $this->getBackingStore()->get('guestsCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'guestsCount'");
    }

    /**
     * Gets the hasMembersFromOtherTenants property value. Indicates whether external members are included on the channel.
     * @return bool|null
    */
    public function getHasMembersFromOtherTenants(): ?bool {
        $val = $this->getBackingStore()->get('hasMembersFromOtherTenants');
        if (is_null($val) || is_bool($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'hasMembersFromOtherTenants'");
    }

    /**
     * Gets the membersCount property value. Count of members in a channel.
     * @return int|null
    */
    public function getMembersCount(): ?int {
        $val = $this->getBackingStore()->get('membersCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'membersCount'");
    }

    /**
     * Gets the @odata.type property value. The OdataType property
     * @return string|null
    */
    public function getOdataType(): ?string {
        $val = $this->getBackingStore()->get('odataType');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'odataType'");
    }

    /**
     * Gets the ownersCount property value. Count of owners in a channel.
     * @return int|null
    */
    public function getOwnersCount(): ?int {
        $val = $this->getBackingStore()->get('ownersCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'ownersCount'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        $writer->writeIntegerValue('guestsCount', $this->getGuestsCount());
        $writer->writeBooleanValue('hasMembersFromOtherTenants', $this->getHasMembersFromOtherTenants());
        $writer->writeIntegerValue('membersCount', $this->getMembersCount());
        $writer->writeStringValue('@odata.type', $this->getOdataType());
        $writer->writeIntegerValue('ownersCount', $this->getOwnersCount());
        $writer->writeAdditionalData($this->getAdditionalData());
    }

    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param array<string,mixed> $value Value to set for the AdditionalData property.
    */
    public function setAdditionalData(?array $value): void {
        $this->getBackingStore()->set('additionalData', $value);
    }

    /**
     * Sets the BackingStore property value. Stores model information.
     * @param BackingStore $value Value to set for the BackingStore property.
    */
    public function setBackingStore(BackingStore $value): void {
        $this->backingStore = $value;
    }

    /**
     * Sets the guestsCount property value. Count of guests in a channel.
     * @param int|null $value Value to set for the guestsCount property.
    */
    public function setGuestsCount(?int $value): void {
        $this->getBackingStore()->set('guestsCount', $value);
    }

    /**
     * Sets the hasMembersFromOtherTenants property value. Indicates whether external members are included on the channel.
     * @param bool|null $value Value to set for the hasMembersFromOtherTenants property.
    */
    public function setHasMembersFromOtherTenants(?bool $value): void {
        $this->getBackingStore()->set('hasMembersFromOtherTenants', $value);
    }

    /**
     * Sets the membersCount property value. Count of members in a channel.
     * @param int|null $value Value to set for the membersCount property.
    */
    public function setMembersCount(?int $value): void {
        $this->getBackingStore()->set('membersCount', $value);
    }

    /**
     * Sets the @odata.type property value. The OdataType property
     * @param string|null $value Value to set for the @odata.type property.
    */
    public function setOdataType(?string $value): void {
        $this->getBackingStore()->set('odataType', $value);
    }

    /**
     * Sets the ownersCount property value. Count of owners in a channel.
     * @param int|null $value Value to set for the ownersCount property.
    */
    public function setOwnersCount(?int $value): void {
        $this->getBackingStore()->set('ownersCount', $value);
    }

}
