<?php
/* oAuth.php Azure AD oAuth Class
 *
 */

define('_OAUTH_LOGOUT', 'https://login.microsoftonline.com/common/wsfederation?wa=wsignout1.0');
define('_OAUTH_SCOPE', 'openid%20offline_access%20profile%20user.read%20email%20https://graph.microsoft.com/Directory.Read.All');
#define('_OAUTH_SCOPE', 'https://graph.microsoft.com/.default');

define('_OAUTH_GRAPH_URL', 'https://graph.microsoft.com/v1.0');
define('_OAUTH_ME_URL', 'https://graph.microsoft.com/v1.0/me');

require_once('database.php');

use Microsoft\Kiota\Authentication\Oauth\AuthorizationCodeContext;
use Microsoft\Graph\Core\Authentication\GraphPhpLeagueAuthenticationProvider;
use Microsoft\Graph\GraphServiceClient;
use Microsoft\Kiota\Abstractions\ApiException;
use Microsoft\Kiota\Authentication\Oauth\OnBehalfOfContext;

class oAuth {
  var $Token;
  var $idToken; // Object formed from idToken in response
  var $oAuthVerifier;
  var $oAuthChallenge;
  var $oAuthChallengeMethod;
  var $userRoles;
  var $isLoggedIn;
  var $Graph = null;

  var $code = '';

  public $oAuthSession;

  function __construct($allowAnonymous = '0') {
    if (session_status() == PHP_SESSION_NONE) {
      zm_session_start();
    }
    #$url = ZM_URL . $_SERVER['REQUEST_URI'];
    $url = ZM_URL . '?view=console';

    $oAuthSession = null;
    // check session key against database. If it's expired or doesnt exist then forward to Azure AD
    if (isset($_SESSION['oAuthSessionKey'])) {
      $oAuthSession = $this->oAuthSession = dbFetchOne('SELECT * FROM oAuthSessions WHERE SessionKey=?',
        NULL, [$_SESSION['oAuthSessionKey']]);
    } 
    if (!$oAuthSession) {
      // Generate the code verifier and challenge
      $this->oAuthChallenge();
      // Generate a session key and store in cookie, then populate database
      $_SESSION['oAuthSessionKey'] = $this->uuid();
      $oAuthSession = $this->oAuthSession = [
        'SessionKey'=>$_SESSION['oAuthSessionKey'],
        'Redir'=>$url,
        'CodeVerifier'=>$this->oAuthVerifier,
        'Expires'=> date('Y-m-d H:i:s', strtotime('+5 minutes'))
      ];
      dbInsert('oAuthSessions', $this->oAuthSession);
      $this->oAuthSession['AuthId'] = dbInsertId();
      if (!$this->oAuthSession['AuthId']) ZM\Fatal("WTF");
    }

    if (empty($oAuthSession['IDToken'])) {
      $this->oAuthVerifier = $oAuthSession['CodeVerifier'];
      $this->oAuthChallenge();
    } else {
      if (strtotime($oAuthSession['Expires']) < time()+600) $this->refresh();

      //Populate userData and userName from the JWT stored in the database.
      $this->Token = $oAuthSession['Token'];
      if ($oAuthSession['IDToken']) {
        $idToken = $this->idToken = json_decode($oAuthSession['IDToken']);

        ZM\Debug(print_r($idToken, true));
        $this->userName = $idToken->preferred_username;
        $this->Name = $idToken->name;
        if (isset($idToken->roles)) {
          $this->userRoles = $idToken->roles;
        } else {
          $this->userRoles = array('Default Access');
        }
        $this->isLoggedIn = 1;
      }
    } // end if oAuthSession[TokenID]

    // Clean up old entries
    // The refresh token is valid for 72 hours by default, but there doesn't seem to be a way to see when the specific one issued expires. So assume anything 72 hours past the expiry of the access token is gone and delete.
    $maxRefresh = strtotime('-72 hour');
    dbQuery('DELETE FROM oAuthSessions WHERE Expires < ?', [date('Y-m-d H:i:s', $maxRefresh)]);
  } // construct

  public function refresh() {
    $oAuthSession = $this->oAuthSession;
    ZM\Debug("Refresh because ".$oAuthSession['Expires'].':'.strtotime($oAuthSession['Expires']). ' < '.time()+600);
    //attempt token refresh
    if (!$oAuthSession['RefreshToken']) {
      ZM\Warn("called refresh without refreshtoken");
      return;
    }

    $oauthRequest = $this->generateRequest(implode('&',[
      'grant_type=refresh_token',
      'refresh_token=' . $oAuthSession['RefreshToken'],
      'scope=' . _OAUTH_SCOPE]));
    $oAuthSessionponse = $this->postRequest('token', $oauthRequest);
    $reply = json_decode($oAuthSessionponse);
    if ($reply->error) {
      if(substr($reply->error_description, 0, 12) == 'AADSTS70008:') {
        //refresh token expired
        ZM\Debug("REFRESH TOKEN expired");
        dbQuery('UPDATE oAuthSessions SET Redir=?, RefreshToken=? Expires=? WHERE AuthId=?',
          [$url, '', date('Y-m-d H:i:s', strtotime('+5 minutes')), $oAuthSession['AuthID']]);
        $oAuthURL = 'https://login.microsoftonline.com/' . ZM_OAUTH_TENANTID . '/oauth2/v2.0/' . 'authorize?response_type=code&client_id=' . ZM_OAUTH_CLIENTID . '&redirect_uri=' . urlencode(ZM_URL) . '&scope=' . _OAUTH_SCOPE . '&code_challenge=' . $this->oAuthChallenge . '&code_challenge_method=' . $this->oAuthChallengeMethod;
        header('Location: ' . $oAuthURL);
        exit;
      }
      ZM\Error($reply->error_description);
      exit;
    }
    $idToken = base64_decode(explode('.', $reply->id_token)[1]);
    $this->updateSession([
      'Token'=>$reply->access_token,
      'RefreshToken'=>$reply->refresh_token,
      'IDToken' => $idToken, 
      'Redir' => '',
      'Expires' => date('Y-m-d H:i:s', strtotime('+' . $reply->expires_in . ' seconds')),
    ]);
  } // end function refresh

  public function login($username, $password) {
    $request = $this->generateRequest(implode('&',[
      'grant_type=password',
      'scope='._OAUTH_SCOPE,
      'username='.$username,
      'password='.$password,
    ]));
    $response = $this->postRequest('token', $request);
    if (!$response) {
      ZM\Error('No response from token request');
      return false;
    }
    ZM\Debug(print_r($response, true));
    $reply = json_decode($response);
    if (property_exists($reply, 'error')) {
      ZM\Error($reply->error_description);
      global $redirect;
      $redirect = '/';
      return false;
    }

    $idToken = base64_decode(explode('.', $reply->id_token)[1]);
    $this->idToken = json_decode($idToken);
    $this->updateSession([
      'Token' => $reply->access_token,
      'RefreshToken' => $reply->refresh_token,
      'IDToken' => $idToken,
      'Redir' => '',
      'Expires' => date('Y-m-d H:i:s', strtotime('+' . $reply->expires_in . ' seconds')),
    ]);
    $this->isLoggedIn = 1;
    return true;
  }
  public function redirect_to_login() {
    // Redirect to Azure AD login page
    $oAuthURL = 'https://login.microsoftonline.com/' . ZM_OAUTH_TENANTID . '/oauth2/v2.0/' .
      'authorize?response_type=code&client_id=' . ZM_OAUTH_CLIENTID .
      '&redirect_uri=' . urlencode(ZM_URL) .
      '&scope=' . _OAUTH_SCOPE .
      '&code_challenge=' . $this->oAuthChallenge .
      '&code_challenge_method=' . $this->oAuthChallengeMethod;
    ZM\Debug("Redirecting to microsoft login at $oAuthURL");
    header('Location: ' . $oAuthURL);
    session_write_close();
    exit;
  }

  function reset() {
    // Logout action selected, clear from database and browser cookie, redirect to logout URL
    if (empty($this->oAuthSession['AuthID'])) {
    dbQuery('DELETE FROM oAuthSessions WHERE SessionKey=?', [$this->oAuthSession['SessionKey']]);
    } else {
    dbQuery('DELETE FROM oAuthSessions WHERE AuthId=?', [$this->oAuthSession['AuthID']]);
    }
    unset($_SESSION['oAuthSessionKey']);
  }

  function logout() {
    $this->reset();
    ZM\Debug("Logout, redirecting to "._OAUTH_LOGOUT);
    global $redirect;
    $redirect = _OAUTH_LOGOUT;
    return;
  }

  function check_code($code) {
    $oauthRequest = $this->generateRequest(implode('&',[
      'grant_type=authorization_code',
      'redirect_uri='.urlencode(ZM_URL),
      'code='.$code,
      'code_verifier='.$this->oAuthVerifier]));

    $response = $this->postRequest('token', $oauthRequest);

    // Decode response from Azure AD. Extract JWT data from supplied access_token and id_token and update database.
    if (!$response) {
      ZM\Error('Unknown error acquiring token');
      return false;
    }
    ZM\Debug(print_r($response, true));
    $reply = json_decode($response);
    if (property_exists($reply, 'error')) {
      ZM\Error($reply->error_description);
      $this->reset();
      return false;
    }

    $idToken = base64_decode(explode('.', $reply->id_token)[1]);
    $this->code = $code;
    $this->idToken = json_decode($idToken);
    $this->updateSession([
      'Token' => $reply->access_token,
      'RefreshToken' => $reply->refresh_token,
      'IDToken' => $idToken,
      'Redir' => '',
      'Expires' => date('Y-m-d H:i:s', strtotime('+' . $reply->expires_in . ' seconds'))
    ]);
    $this->isLoggedIn = 1;
    return true;
  } // end function check_code($code)

  function checkUserRole($role) {
    // Check that the requested role has been assigned to the user
    if (in_array($role, $this->userRoles)) {
      return 1;
    }
    return;
  }

  function uuid() {
    //uuid function is not my code, but unsure who the original author is. KN
    //uuid version 4
    return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
      // 32 bits for "time_low"
      mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),
      // 16 bits for "time_mid"
      mt_rand( 0, 0xffff ),
      // 16 bits for "time_hi_and_version",
      // four most significant bits holds version number 4
      mt_rand( 0, 0x0fff ) | 0x4000,
      // 16 bits, 8 bits for "clk_seq_hi_res",
      // 8 bits for "clk_seq_low",
      // two most significant bits holds zero and one for variant DCE1.1
      mt_rand( 0, 0x3fff ) | 0x8000,
      // 48 bits for "node"
      mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )
    );
  }

  function oAuthChallenge() {
    // Function to generate code verifier and code challenge for oAuth login. See RFC7636 for details. 
    $verifier = $this->oAuthVerifier;
    if (!$this->oAuthVerifier) {
      $chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~';
      $charLen = strlen($chars) - 1;
      $verifier = '';
      for ($i = 0; $i < 128; $i++) {
        $verifier .= $chars[mt_rand(0, $charLen)];
      }
      $this->oAuthVerifier = $verifier;
    }
    // Challenge = Base64 Url Encode ( SHA256 ( Verifier ) )
    // Pack (H) to convert 64 char hash into 32 byte hex
    // As there is no B64UrlEncode we use strtr to swap +/ for -_ and then strip off the =
    $this->oAuthChallenge = str_replace('=', '', strtr(base64_encode(pack('H*', hash('sha256', $verifier))), '+/', '-_'));
    $this->oAuthChallengeMethod = 'S256';
  }

  function generateRequest($data) {
    if (ZM_OAUTH_SECRET) {
      ZM\Debug("Using secret method");
      // Use the client secret instead
      return $data . '&client_id='.ZM_OAUTH_CLIENTID.'&client_secret=' . urlencode(ZM_OAUTH_SECRET);
    }

    if (ZM_OAUTH_CERTFILE) {
      ZM\Debug("Using certificate method");
      // Use the certificate specified
      //https://docs.microsoft.com/en-us/azure/active-directory/develop/active-directory-certificate-credentials
      $cert = file_get_contents(ZM_OAUTH_CERTFILE);
      $certKey = openssl_pkey_get_private(file_get_contents(ZM_OAUTH_KEYFILE));
      $certHash = openssl_x509_fingerprint($cert);
      $certHash = base64_encode(hex2bin($certHash));
      $caHeader = json_encode(array('alg' => 'RS256', 'typ' => 'JWT', 'x5t' => $certHash));
      $caPayload = json_encode(array('aud' => 'https://login.microsoftonline.com/' . ZM_OAUTH_TENANTID . '/v2.0',
        'exp' => date('U', strtotime('+10 minute')),
        'iss' => ZM_OAUTH_CLIENTID,
        'jti' => $this->uuid(),
        'nbf' => date('U'),
        'sub' => ZM_OAUTH_CLIENTID));
      $caSignature = '';

      $caData = $this->base64UrlEncode($caHeader) . '.' . $this->base64UrlEncode($caPayload);
      openssl_sign($caData, $caSignature, $certKey, OPENSSL_ALGO_SHA256);
      $caSignature = $this->base64UrlEncode($caSignature);
      $clientAssertion = $caData . '.' . $caSignature;
      return $data . '&client_id='.ZM_OAUTH_CLIENTID.'&client_assertion=' . $clientAssertion . '&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer';
    }
    ZM\Debug("Using no method ".$data);
    return $data. '&client_id='.ZM_OAUTH_CLIENTID;
  } // end generateRequest($data)

	function postRequest($endpoint, $data) {
    $url = 'https://login.microsoftonline.com/' . ZM_OAUTH_TENANTID . '/oauth2/v2.0/' . $endpoint;
    ZM\Debug("post to $url with data: ".print_r($data, true));
    $ch = curl_init($url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($ch);
		if ($cError = curl_error($ch)) {
      ZM\Error($cError);
			echo $this->errorMessage($cError);
			exit;
		}
		curl_close($ch);
		return $response;
	}

  function updateSession($values) {
    dbUpdate('oAuthSessions', $values, ['AuthId'=>$this->oAuthSession['AuthID']]);
    foreach ($values as $k=>$v)
      $this->oAuthSession[$k] = $v;
  }

  public function __call($fn, array $args) {
    ZM\Debug("Calling $fn ".print_r($this->idToken, true));
    if ($this->idToken and $this->idToken->$fn) {
      return $this->idToken->$fn;
    }
    ZM\Debug("Not in idToken  $fn . " . ($this->idToken->$fn));
    return null;
  }

  public function Graph() {
    if (!$this->Graph) {
      $this->Graph = new oAuthGraph($this);
    }
    return $this->Graph;
  }
} // end class oAuth

class oAuthGraph {
  var $oAuth;
  var $tokenRequestContext;
  var $graphServiceClient;

  function __construct($oAuth) {
    $this->oAuth = $oAuth;

    $oAuthSession = $oAuth->oAuthSession;
    if (!$oAuthSession['Token']) {
      ZM\Error("Must have token in oAuthGraph: ".print_r($oAuthSession, true));
      return;
    } else {
      ZM\Debug("Token: ".$oAuthSession['Token']);
    } 
    if (ZM_OAUTH_SECRET) {
      $this->tokenRequestContext = new OnBehalfOfContext(
        ZM_OAUTH_TENANTID, ZM_OAUTH_CLIENTID, ZM_OAUTH_SECRET, $oAuthSession['Token']);
      ZM\Debug(print_r($this->tokenRequestContext, true));
    } else if (ZM_OAUTH_CERTIFICATE) {
      $this->tokenRequestContext = new OnBehalfOfCertificateContext(
        ZM_OAUTH_TENANTID, ZM_OAUTH_CLIENTID, $oAuthSession['Token'],
        ZM_OAUTH_CERTFILE, ZM_OAUTH_KEYFILE, '');
    }
    $scopes = [ 'User.Read' ];
    $this->graphServiceClient = new GraphServiceClient($this->tokenRequestContext, $scopes);
  }

  function getProfile() {
    $profile = json_decode($this->sendGetRequest(_OAUTH_ME_URL));
    return $profile;
  }

  function getPhoto() {
    //Photo is a bit different, we need to request the image data which will include content type, size etc, then request the image
    $photoType = json_decode($this->sendGetRequest(_OAUTH_ME_URL.'/photo/'));
    if (isset($photoType->{'@odata.mediaContentType'})) {
      $photo = $this->sendGetRequest(_OATH_ME_URL.'/photo/%24value');
      return '<img src="data:' . $photoType->{'@odata.mediaContentType'} . ';base64,' . base64_encode($photo) . '" alt="User Photo" />';
    }
    return;
  }

  function getGroups() {
    $response = json_decode($this->sendGetRequest(_OAUTH_GRAPH_URL.'/$metadata#groups(displayName,id)'));
    return $response->value;
  }

  function getMyGroups() {
    $response = json_decode($this->sendGetRequest(_OAUTH_ME_URL.'/memberOf/microsoft.graph.group'));
    #ZM\Debug(print_r($response, true));
    return $response->value;
    try {
      #$user = $this->graphServiceClient->users()->byUserId('[userPrincipalName]')->get()->wait();
      $user = $this->graphServiceClient->me()->get()->wait();
      ZM\Debug($user);
    } catch (ApiException $ex) {
      echo $ex->getError()->getMessage();
    }
  }

  function sendGetRequest($url, $ContentType = 'application/json') {
    ZM\Debug("oAuthGraph::sendGetRequest: $url ".$this->oAuth->oAuthSession['Token']);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer ' . $this->oAuth->oAuthSession['Token'], 'Content-Type: ' . $ContentType));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);

    curl_close($ch);
    ZM\Debug($response);
    return $response;
  }
} // end oAuthGraph
?>
