<?php

namespace Microsoft\Graph\Generated\Models;

use Microsoft\Kiota\Abstractions\Serialization\AdditionalDataHolder;
use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;
use Microsoft\Kiota\Abstractions\Store\BackedModel;
use Microsoft\Kiota\Abstractions\Store\BackingStore;
use Microsoft\Kiota\Abstractions\Store\BackingStoreFactorySingleton;
use Microsoft\Kiota\Abstractions\Types\TypeUtils;

/**
 * Windows device malware overview.
*/
class WindowsMalwareOverview implements AdditionalDataHolder, BackedModel, Parsable 
{
    /**
     * @var BackingStore $backingStore Stores model information.
    */
    private BackingStore $backingStore;
    
    /**
     * Instantiates a new windowsMalwareOverview and sets the default values.
    */
    public function __construct() {
        $this->backingStore = BackingStoreFactorySingleton::getInstance()->createBackingStore();
        $this->setAdditionalData([]);
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return WindowsMalwareOverview
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): WindowsMalwareOverview {
        return new WindowsMalwareOverview();
    }

    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return array<string, mixed>|null
    */
    public function getAdditionalData(): ?array {
        $val = $this->getBackingStore()->get('additionalData');
        if (is_null($val) || is_array($val)) {
            /** @var array<string, mixed>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'additionalData'");
    }

    /**
     * Gets the BackingStore property value. Stores model information.
     * @return BackingStore
    */
    public function getBackingStore(): BackingStore {
        return $this->backingStore;
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return  [
            'malwareCategorySummary' => fn(ParseNode $n) => $o->setMalwareCategorySummary($n->getCollectionOfObjectValues([WindowsMalwareCategoryCount::class, 'createFromDiscriminatorValue'])),
            'malwareDetectedDeviceCount' => fn(ParseNode $n) => $o->setMalwareDetectedDeviceCount($n->getIntegerValue()),
            'malwareExecutionStateSummary' => fn(ParseNode $n) => $o->setMalwareExecutionStateSummary($n->getCollectionOfObjectValues([WindowsMalwareExecutionStateCount::class, 'createFromDiscriminatorValue'])),
            'malwareNameSummary' => fn(ParseNode $n) => $o->setMalwareNameSummary($n->getCollectionOfObjectValues([WindowsMalwareNameCount::class, 'createFromDiscriminatorValue'])),
            'malwareSeveritySummary' => fn(ParseNode $n) => $o->setMalwareSeveritySummary($n->getCollectionOfObjectValues([WindowsMalwareSeverityCount::class, 'createFromDiscriminatorValue'])),
            'malwareStateSummary' => fn(ParseNode $n) => $o->setMalwareStateSummary($n->getCollectionOfObjectValues([WindowsMalwareStateCount::class, 'createFromDiscriminatorValue'])),
            '@odata.type' => fn(ParseNode $n) => $o->setOdataType($n->getStringValue()),
            'osVersionsSummary' => fn(ParseNode $n) => $o->setOsVersionsSummary($n->getCollectionOfObjectValues([OsVersionCount::class, 'createFromDiscriminatorValue'])),
            'totalDistinctMalwareCount' => fn(ParseNode $n) => $o->setTotalDistinctMalwareCount($n->getIntegerValue()),
            'totalMalwareCount' => fn(ParseNode $n) => $o->setTotalMalwareCount($n->getIntegerValue()),
        ];
    }

    /**
     * Gets the malwareCategorySummary property value. List of device counts per malware category
     * @return array<WindowsMalwareCategoryCount>|null
    */
    public function getMalwareCategorySummary(): ?array {
        $val = $this->getBackingStore()->get('malwareCategorySummary');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, WindowsMalwareCategoryCount::class);
            /** @var array<WindowsMalwareCategoryCount>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'malwareCategorySummary'");
    }

    /**
     * Gets the malwareDetectedDeviceCount property value. Count of devices with malware detected in the last 30 days
     * @return int|null
    */
    public function getMalwareDetectedDeviceCount(): ?int {
        $val = $this->getBackingStore()->get('malwareDetectedDeviceCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'malwareDetectedDeviceCount'");
    }

    /**
     * Gets the malwareExecutionStateSummary property value. List of device counts per malware execution state
     * @return array<WindowsMalwareExecutionStateCount>|null
    */
    public function getMalwareExecutionStateSummary(): ?array {
        $val = $this->getBackingStore()->get('malwareExecutionStateSummary');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, WindowsMalwareExecutionStateCount::class);
            /** @var array<WindowsMalwareExecutionStateCount>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'malwareExecutionStateSummary'");
    }

    /**
     * Gets the malwareNameSummary property value. List of device counts per malware
     * @return array<WindowsMalwareNameCount>|null
    */
    public function getMalwareNameSummary(): ?array {
        $val = $this->getBackingStore()->get('malwareNameSummary');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, WindowsMalwareNameCount::class);
            /** @var array<WindowsMalwareNameCount>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'malwareNameSummary'");
    }

    /**
     * Gets the malwareSeveritySummary property value. List of active malware counts per malware severity
     * @return array<WindowsMalwareSeverityCount>|null
    */
    public function getMalwareSeveritySummary(): ?array {
        $val = $this->getBackingStore()->get('malwareSeveritySummary');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, WindowsMalwareSeverityCount::class);
            /** @var array<WindowsMalwareSeverityCount>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'malwareSeveritySummary'");
    }

    /**
     * Gets the malwareStateSummary property value. List of device counts per malware state
     * @return array<WindowsMalwareStateCount>|null
    */
    public function getMalwareStateSummary(): ?array {
        $val = $this->getBackingStore()->get('malwareStateSummary');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, WindowsMalwareStateCount::class);
            /** @var array<WindowsMalwareStateCount>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'malwareStateSummary'");
    }

    /**
     * Gets the @odata.type property value. The OdataType property
     * @return string|null
    */
    public function getOdataType(): ?string {
        $val = $this->getBackingStore()->get('odataType');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'odataType'");
    }

    /**
     * Gets the osVersionsSummary property value. List of device counts with malware per windows OS version
     * @return array<OsVersionCount>|null
    */
    public function getOsVersionsSummary(): ?array {
        $val = $this->getBackingStore()->get('osVersionsSummary');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, OsVersionCount::class);
            /** @var array<OsVersionCount>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'osVersionsSummary'");
    }

    /**
     * Gets the totalDistinctMalwareCount property value. Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
     * @return int|null
    */
    public function getTotalDistinctMalwareCount(): ?int {
        $val = $this->getBackingStore()->get('totalDistinctMalwareCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'totalDistinctMalwareCount'");
    }

    /**
     * Gets the totalMalwareCount property value. Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
     * @return int|null
    */
    public function getTotalMalwareCount(): ?int {
        $val = $this->getBackingStore()->get('totalMalwareCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'totalMalwareCount'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        $writer->writeCollectionOfObjectValues('malwareCategorySummary', $this->getMalwareCategorySummary());
        $writer->writeIntegerValue('malwareDetectedDeviceCount', $this->getMalwareDetectedDeviceCount());
        $writer->writeCollectionOfObjectValues('malwareExecutionStateSummary', $this->getMalwareExecutionStateSummary());
        $writer->writeCollectionOfObjectValues('malwareNameSummary', $this->getMalwareNameSummary());
        $writer->writeCollectionOfObjectValues('malwareSeveritySummary', $this->getMalwareSeveritySummary());
        $writer->writeCollectionOfObjectValues('malwareStateSummary', $this->getMalwareStateSummary());
        $writer->writeStringValue('@odata.type', $this->getOdataType());
        $writer->writeCollectionOfObjectValues('osVersionsSummary', $this->getOsVersionsSummary());
        $writer->writeIntegerValue('totalDistinctMalwareCount', $this->getTotalDistinctMalwareCount());
        $writer->writeIntegerValue('totalMalwareCount', $this->getTotalMalwareCount());
        $writer->writeAdditionalData($this->getAdditionalData());
    }

    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param array<string,mixed> $value Value to set for the AdditionalData property.
    */
    public function setAdditionalData(?array $value): void {
        $this->getBackingStore()->set('additionalData', $value);
    }

    /**
     * Sets the BackingStore property value. Stores model information.
     * @param BackingStore $value Value to set for the BackingStore property.
    */
    public function setBackingStore(BackingStore $value): void {
        $this->backingStore = $value;
    }

    /**
     * Sets the malwareCategorySummary property value. List of device counts per malware category
     * @param array<WindowsMalwareCategoryCount>|null $value Value to set for the malwareCategorySummary property.
    */
    public function setMalwareCategorySummary(?array $value): void {
        $this->getBackingStore()->set('malwareCategorySummary', $value);
    }

    /**
     * Sets the malwareDetectedDeviceCount property value. Count of devices with malware detected in the last 30 days
     * @param int|null $value Value to set for the malwareDetectedDeviceCount property.
    */
    public function setMalwareDetectedDeviceCount(?int $value): void {
        $this->getBackingStore()->set('malwareDetectedDeviceCount', $value);
    }

    /**
     * Sets the malwareExecutionStateSummary property value. List of device counts per malware execution state
     * @param array<WindowsMalwareExecutionStateCount>|null $value Value to set for the malwareExecutionStateSummary property.
    */
    public function setMalwareExecutionStateSummary(?array $value): void {
        $this->getBackingStore()->set('malwareExecutionStateSummary', $value);
    }

    /**
     * Sets the malwareNameSummary property value. List of device counts per malware
     * @param array<WindowsMalwareNameCount>|null $value Value to set for the malwareNameSummary property.
    */
    public function setMalwareNameSummary(?array $value): void {
        $this->getBackingStore()->set('malwareNameSummary', $value);
    }

    /**
     * Sets the malwareSeveritySummary property value. List of active malware counts per malware severity
     * @param array<WindowsMalwareSeverityCount>|null $value Value to set for the malwareSeveritySummary property.
    */
    public function setMalwareSeveritySummary(?array $value): void {
        $this->getBackingStore()->set('malwareSeveritySummary', $value);
    }

    /**
     * Sets the malwareStateSummary property value. List of device counts per malware state
     * @param array<WindowsMalwareStateCount>|null $value Value to set for the malwareStateSummary property.
    */
    public function setMalwareStateSummary(?array $value): void {
        $this->getBackingStore()->set('malwareStateSummary', $value);
    }

    /**
     * Sets the @odata.type property value. The OdataType property
     * @param string|null $value Value to set for the @odata.type property.
    */
    public function setOdataType(?string $value): void {
        $this->getBackingStore()->set('odataType', $value);
    }

    /**
     * Sets the osVersionsSummary property value. List of device counts with malware per windows OS version
     * @param array<OsVersionCount>|null $value Value to set for the osVersionsSummary property.
    */
    public function setOsVersionsSummary(?array $value): void {
        $this->getBackingStore()->set('osVersionsSummary', $value);
    }

    /**
     * Sets the totalDistinctMalwareCount property value. Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
     * @param int|null $value Value to set for the totalDistinctMalwareCount property.
    */
    public function setTotalDistinctMalwareCount(?int $value): void {
        $this->getBackingStore()->set('totalDistinctMalwareCount', $value);
    }

    /**
     * Sets the totalMalwareCount property value. Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
     * @param int|null $value Value to set for the totalMalwareCount property.
    */
    public function setTotalMalwareCount(?int $value): void {
        $this->getBackingStore()->set('totalMalwareCount', $value);
    }

}
