<?php

namespace Microsoft\Graph\Generated\Security\ThreatIntelligence\Hosts\Item\Reputation;

use Microsoft\Kiota\Abstractions\BaseRequestConfiguration;
use Microsoft\Kiota\Abstractions\RequestOption;

/**
 * Configuration for the request such as headers, query parameters, and middleware options.
*/
class ReputationRequestBuilderGetRequestConfiguration extends BaseRequestConfiguration 
{
    /**
     * @var ReputationRequestBuilderGetQueryParameters|null $queryParameters Request query parameters
    */
    public ?ReputationRequestBuilderGetQueryParameters $queryParameters = null;
    
    /**
     * Instantiates a new reputationRequestBuilderGetRequestConfiguration and sets the default values.
     * @param array<string, array<string>|string>|null $headers Request headers
     * @param array<RequestOption>|null $options Request options
     * @param ReputationRequestBuilderGetQueryParameters|null $queryParameters Request query parameters
    */
    public function __construct(?array $headers = null, ?array $options = null, ?ReputationRequestBuilderGetQueryParameters $queryParameters = null) {
        parent::__construct($headers ?? [], $options ?? []);
        $this->queryParameters = $queryParameters;
    }

    /**
     * Instantiates a new reputationRequestBuilderGetQueryParameters.
     * @param array<string>|null $expand Expand related entities
     * @param array<string>|null $select Select properties to be returned
     * @return ReputationRequestBuilderGetQueryParameters
    */
    public static function createQueryParameters(?array $expand = null, ?array $select = null): ReputationRequestBuilderGetQueryParameters {
        return new ReputationRequestBuilderGetQueryParameters($expand, $select);
    }

}
