package ONVIF::PTZ::Types::VideoAttributes;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Bitrate_of :ATTR(:get<Bitrate>);
my %Width_of :ATTR(:get<Width>);
my %Height_of :ATTR(:get<Height>);
my %Encoding_of :ATTR(:get<Encoding>);
my %Framerate_of :ATTR(:get<Framerate>);

__PACKAGE__->_factory(
    [ qw(        Bitrate
        Width
        Height
        Encoding
        Framerate

    ) ],
    {
        'Bitrate' => \%Bitrate_of,
        'Width' => \%Width_of,
        'Height' => \%Height_of,
        'Encoding' => \%Encoding_of,
        'Framerate' => \%Framerate_of,
    },
    {
        'Bitrate' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'Width' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'Height' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'Encoding' => 'ONVIF::PTZ::Types::VideoEncoding',
        'Framerate' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
    },
    {

        'Bitrate' => 'Bitrate',
        'Width' => 'Width',
        'Height' => 'Height',
        'Encoding' => 'Encoding',
        'Framerate' => 'Framerate',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::VideoAttributes

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoAttributes from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Bitrate


=item * Width


=item * Height


=item * Encoding


=item * Framerate




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::VideoAttributes
   Bitrate =>  $some_value, # int
   Width =>  $some_value, # int
   Height =>  $some_value, # int
   Encoding => $some_value, # VideoEncoding
   Framerate =>  $some_value, # float
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

