package ONVIF::Device::Types::EventSubscription;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Filter_of :ATTR(:get<Filter>);
my %SubscriptionPolicy_of :ATTR(:get<SubscriptionPolicy>);

__PACKAGE__->_factory(
    [ qw(        Filter
        SubscriptionPolicy

    ) ],
    {
        'Filter' => \%Filter_of,
        'SubscriptionPolicy' => \%SubscriptionPolicy_of,
    },
    {
        'Filter' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyType',

        'SubscriptionPolicy' => 'ONVIF::Device::Types::EventSubscription::_SubscriptionPolicy',
    },
    {

        'Filter' => 'Filter',
        'SubscriptionPolicy' => 'SubscriptionPolicy',
    }
);

} # end BLOCK




package ONVIF::Device::Types::EventSubscription::_SubscriptionPolicy;
use strict;
use warnings;
{
our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables


__PACKAGE__->_factory(
    [ qw(
    ) ],
    {
    },
    {
    },
    {

    }
);

} # end BLOCK







}







1;


=pod

=head1 NAME

ONVIF::Device::Types::EventSubscription

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
EventSubscription from the namespace http://www.onvif.org/ver10/schema.

Subscription handling in the same way as base notification subscription.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Filter


=item * SubscriptionPolicy




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::EventSubscription
   Filter =>  $some_value, # anyType
   SubscriptionPolicy =>  {
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

