package ONVIF::PTZ::Types::ImageStabilizationOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Mode_of :ATTR(:get<Mode>);
my %Level_of :ATTR(:get<Level>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Mode
        Level
        Extension

    ) ],
    {
        'Mode' => \%Mode_of,
        'Level' => \%Level_of,
        'Extension' => \%Extension_of,
    },
    {
        'Mode' => 'ONVIF::PTZ::Types::ImageStabilizationMode',
        'Level' => 'ONVIF::PTZ::Types::FloatRange',
        'Extension' => 'ONVIF::PTZ::Types::ImageStabilizationOptionsExtension',
    },
    {

        'Mode' => 'Mode',
        'Level' => 'Level',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::ImageStabilizationOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ImageStabilizationOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Mode


=item * Level


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::ImageStabilizationOptions
   Mode => $some_value, # ImageStabilizationMode
   Level =>  { # ONVIF::PTZ::Types::FloatRange
     Min =>  $some_value, # float
     Max =>  $some_value, # float
   },
   Extension =>  { # ONVIF::PTZ::Types::ImageStabilizationOptionsExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

