
package WSNotification::Elements::RenewResponse;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://docs.oasis-open.org/wsn/b-2' }

__PACKAGE__->__set_name('RenewResponse');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %TerminationTime_of :ATTR(:get<TerminationTime>);
my %CurrentTime_of :ATTR(:get<CurrentTime>);

__PACKAGE__->_factory(
    [ qw(        TerminationTime
        CurrentTime

    ) ],
    {
        'TerminationTime' => \%TerminationTime_of,
        'CurrentTime' => \%CurrentTime_of,
    },
    {
        'TerminationTime' => 'WSNotification::Elements::TerminationTime',

        'CurrentTime' => 'WSNotification::Elements::CurrentTime',

    },
    {

        'TerminationTime' => '',
        'CurrentTime' => '',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

WSNotification::Elements::RenewResponse

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
RenewResponse from the namespace http://docs.oasis-open.org/wsn/b-2.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * TerminationTime

 $element->set_TerminationTime($data);
 $element->get_TerminationTime();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 



=item * CurrentTime

 $element->set_CurrentTime($data);
 $element->get_CurrentTime();


Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 




=back


=head1 METHODS

=head2 new

 my $element = WSNotification::Elements::RenewResponse->new($data);

Constructor. The following data structure may be passed to new():

 {
   TerminationTime =>  $some_value, # dateTime
   CurrentTime =>  $some_value, # dateTime
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

