package ONVIF::Analytics::Types::AnalyticsDeviceEngineConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %EngineConfiguration_of :ATTR(:get<EngineConfiguration>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        EngineConfiguration
        Extension

    ) ],
    {
        'EngineConfiguration' => \%EngineConfiguration_of,
        'Extension' => \%Extension_of,
    },
    {
        'EngineConfiguration' => 'ONVIF::Analytics::Types::EngineConfiguration',
        'Extension' => 'ONVIF::Analytics::Types::AnalyticsDeviceEngineConfigurationExtension',
    },
    {

        'EngineConfiguration' => 'EngineConfiguration',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::AnalyticsDeviceEngineConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AnalyticsDeviceEngineConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * EngineConfiguration


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::AnalyticsDeviceEngineConfiguration
   EngineConfiguration =>  { # ONVIF::Analytics::Types::EngineConfiguration
     VideoAnalyticsConfiguration =>  { # ONVIF::Analytics::Types::VideoAnalyticsConfiguration
       AnalyticsEngineConfiguration =>  { # ONVIF::Analytics::Types::AnalyticsEngineConfiguration
         AnalyticsModule =>  { # ONVIF::Analytics::Types::Config
           Parameters =>  { # ONVIF::Analytics::Types::ItemList
             SimpleItem => ,
             ElementItem =>  {
             },
             Extension =>  { # ONVIF::Analytics::Types::ItemListExtension
             },
           },
         },
         Extension =>  { # ONVIF::Analytics::Types::AnalyticsEngineConfigurationExtension
         },
       },
       RuleEngineConfiguration =>  { # ONVIF::Analytics::Types::RuleEngineConfiguration
         Rule =>  { # ONVIF::Analytics::Types::Config
           Parameters =>  { # ONVIF::Analytics::Types::ItemList
             SimpleItem => ,
             ElementItem =>  {
             },
             Extension =>  { # ONVIF::Analytics::Types::ItemListExtension
             },
           },
         },
         Extension =>  { # ONVIF::Analytics::Types::RuleEngineConfigurationExtension
         },
       },
     },
     AnalyticsEngineInputInfo =>  { # ONVIF::Analytics::Types::AnalyticsEngineInputInfo
       InputInfo =>  { # ONVIF::Analytics::Types::Config
         Parameters =>  { # ONVIF::Analytics::Types::ItemList
           SimpleItem => ,
           ElementItem =>  {
           },
           Extension =>  { # ONVIF::Analytics::Types::ItemListExtension
           },
         },
       },
       Extension =>  { # ONVIF::Analytics::Types::AnalyticsEngineInputInfoExtension
       },
     },
   },
   Extension =>  { # ONVIF::Analytics::Types::AnalyticsDeviceEngineConfigurationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

