package ONVIF::Analytics::Types::Rotate;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Mode_of :ATTR(:get<Mode>);
my %Degree_of :ATTR(:get<Degree>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Mode
        Degree
        Extension

    ) ],
    {
        'Mode' => \%Mode_of,
        'Degree' => \%Degree_of,
        'Extension' => \%Extension_of,
    },
    {
        'Mode' => 'ONVIF::Analytics::Types::RotateMode',
        'Degree' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'Extension' => 'ONVIF::Analytics::Types::RotateExtension',
    },
    {

        'Mode' => 'Mode',
        'Degree' => 'Degree',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::Rotate

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Rotate from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Mode


=item * Degree


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::Rotate
   Mode => $some_value, # RotateMode
   Degree =>  $some_value, # int
   Extension =>  { # ONVIF::Analytics::Types::RotateExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

