
package WSDiscovery::Elements::ReplyTo;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.w3.org/2005/08/addressing' }

__PACKAGE__->__set_name('ReplyTo');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();
use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    WSDiscovery::Types::EndpointReferenceType
);

}

1;


=pod

=head1 NAME

WSDiscovery::Elements::ReplyTo

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
ReplyTo from the namespace http://www.w3.org/2005/08/addressing.







=head1 METHODS

=head2 new

 my $element = WSDiscovery::Elements::ReplyTo->new($data);

Constructor. The following data structure may be passed to new():

 { # WSDiscovery::Types::EndpointReferenceType
   Address =>  { value => $some_value },
   ReferenceParameters =>  { # WSDiscovery::Types::ReferenceParametersType
   },
   Metadata =>  { # WSDiscovery::Types::MetadataType
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

