# Contributing to the Microsoft Graph PHP SDK
Thanks for considering making a contribution! Read over our guidelines and we will do our best to see your PRs merged successfully.

**NOTE**: A signed a contribution license agreement is required for all contributions and is checked automatically on new pull requests. You will be asked to read and sign the agreement https://cla.microsoft.com/ after submitting a request to this repository.

There are a few different recommended paths to get contributions into the released version of this library.

## File issues
The best way to get started with a contribution is to start a dialog with us. Sometimes features will be under development or out of scope for this library and it's best to check before starting work on contribution, especially for large work items.

## Pull requests
If you are making documentation changes, feel free to submit a pull request against the **main** branch. All other pull requests should be submitted against the **dev** branch or a specific feature branch. The master branch is intended to represent the code released in the most-recent composer package.

When a new package is about to be released, changes in dev will be merged into master. The package will be generated from master.

Some things to note about this project:

### How the library is built
The PHP SDK has a mix of handwritten "core" files and a folder of autogenerated models and request builder classes.

The models and request builders are generated using [Kiota](https://github.com/microsoft/kiota). **Changes made to the ```Generated``` folder will be overwritten** the next time the generator is run - currently every week on Tuesday. Feel free to contribute to the generated code there.

Hand-written core files are spread across:

- [PHP Core](https://github.com/microsoftgraph/msgraph-sdk-php-core) which contains Graph specific configuration
- [Kiota Abstractions](https://github.com/microsoft/kiota-abstractions-php) which contains all interfaces that tie the SDK together
- [Kiota HTTP using Guzzle](https://github.com/microsoft/kiota-http-guzzle-php) which handles HTTP level concerns
- [Kiota Authentication using PHP League](https://github.com/microsoft/kiota-authentication-phpleague-php) which handles Authentication
- [Kiota Serialization JSON](https://github.com/microsoft/kiota-serialization-json-php) which handles JSON (de)/serialization
- [Kiota Serialization Text](https://github.com/microsoft/kiota-serialization-text-php) which handles `text/plain` (de)/serialization

### How the generator works
You can view the [README](https://github.com/microsoft/kiota) for a full run-through of its capabilities.

For the purposes of the PHP library, the generator runs through an OpenAPI schema description of the Microsoft Graph API (https://github.com/microsoftgraph/msgraph-metadata/blob/master/openapi/v1.0/openapi.yaml) and builds up a list of models and request builders based on the paths.

### When new features are added to the library
Generation happens as part of a manual process that occurs once a significant change or set of changes has been added to the Graph. This may include:
 - A new workload comes to v1.0 of Graph (Microsoft Teams, Batching, etc.)
 - There is significant addition of functionality (Delta Queries, etc.)

However, this is evaluated on a case-by-case basis. If the library is missing v1.0 Graph functionality that you wish to utilize, please [file an issue](https://github.com/microsoftgraph/msgraph-sdk-php/issues).

We do our best to prevent breaking changes from being introduced into the library during this process. If you find a breaking change, please file an issue and we will work to get this resolved ASAP.


