<?php

namespace Microsoft\Graph\Generated\Models\Security;

use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;
use Microsoft\Kiota\Abstractions\Types\TypeUtils;

class MailClusterEvidence extends AlertEvidence implements Parsable 
{
    /**
     * Instantiates a new mailClusterEvidence and sets the default values.
    */
    public function __construct() {
        parent::__construct();
        $this->setOdataType('#microsoft.graph.security.mailClusterEvidence');
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return MailClusterEvidence
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): MailClusterEvidence {
        return new MailClusterEvidence();
    }

    /**
     * Gets the clusterBy property value. The clustering logic of the emails inside the cluster.
     * @return string|null
    */
    public function getClusterBy(): ?string {
        $val = $this->getBackingStore()->get('clusterBy');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'clusterBy'");
    }

    /**
     * Gets the clusterByValue property value. The value utilized to cluster the similar emails.
     * @return string|null
    */
    public function getClusterByValue(): ?string {
        $val = $this->getBackingStore()->get('clusterByValue');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'clusterByValue'");
    }

    /**
     * Gets the emailCount property value. Count of emails in the email cluster.
     * @return int|null
    */
    public function getEmailCount(): ?int {
        $val = $this->getBackingStore()->get('emailCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'emailCount'");
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return array_merge(parent::getFieldDeserializers(), [
            'clusterBy' => fn(ParseNode $n) => $o->setClusterBy($n->getStringValue()),
            'clusterByValue' => fn(ParseNode $n) => $o->setClusterByValue($n->getStringValue()),
            'emailCount' => fn(ParseNode $n) => $o->setEmailCount($n->getIntegerValue()),
            'networkMessageIds' => function (ParseNode $n) {
                $val = $n->getCollectionOfPrimitiveValues();
                if (is_array($val)) {
                    TypeUtils::validateCollectionValues($val, 'string');
                }
                /** @var array<string>|null $val */
                $this->setNetworkMessageIds($val);
            },
            'query' => fn(ParseNode $n) => $o->setQuery($n->getStringValue()),
            'urn' => fn(ParseNode $n) => $o->setUrn($n->getStringValue()),
        ]);
    }

    /**
     * Gets the networkMessageIds property value. Unique identifiers for the emails in the cluster, generated by Microsoft 365.
     * @return array<string>|null
    */
    public function getNetworkMessageIds(): ?array {
        $val = $this->getBackingStore()->get('networkMessageIds');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, 'string');
            /** @var array<string>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'networkMessageIds'");
    }

    /**
     * Gets the query property value. The query used to identify the email cluster.
     * @return string|null
    */
    public function getQuery(): ?string {
        $val = $this->getBackingStore()->get('query');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'query'");
    }

    /**
     * Gets the urn property value. Uniform resource name (URN) of the automated investigation where the cluster was identified.
     * @return string|null
    */
    public function getUrn(): ?string {
        $val = $this->getBackingStore()->get('urn');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'urn'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        parent::serialize($writer);
        $writer->writeStringValue('clusterBy', $this->getClusterBy());
        $writer->writeStringValue('clusterByValue', $this->getClusterByValue());
        $writer->writeIntegerValue('emailCount', $this->getEmailCount());
        $writer->writeCollectionOfPrimitiveValues('networkMessageIds', $this->getNetworkMessageIds());
        $writer->writeStringValue('query', $this->getQuery());
        $writer->writeStringValue('urn', $this->getUrn());
    }

    /**
     * Sets the clusterBy property value. The clustering logic of the emails inside the cluster.
     * @param string|null $value Value to set for the clusterBy property.
    */
    public function setClusterBy(?string $value): void {
        $this->getBackingStore()->set('clusterBy', $value);
    }

    /**
     * Sets the clusterByValue property value. The value utilized to cluster the similar emails.
     * @param string|null $value Value to set for the clusterByValue property.
    */
    public function setClusterByValue(?string $value): void {
        $this->getBackingStore()->set('clusterByValue', $value);
    }

    /**
     * Sets the emailCount property value. Count of emails in the email cluster.
     * @param int|null $value Value to set for the emailCount property.
    */
    public function setEmailCount(?int $value): void {
        $this->getBackingStore()->set('emailCount', $value);
    }

    /**
     * Sets the networkMessageIds property value. Unique identifiers for the emails in the cluster, generated by Microsoft 365.
     * @param array<string>|null $value Value to set for the networkMessageIds property.
    */
    public function setNetworkMessageIds(?array $value): void {
        $this->getBackingStore()->set('networkMessageIds', $value);
    }

    /**
     * Sets the query property value. The query used to identify the email cluster.
     * @param string|null $value Value to set for the query property.
    */
    public function setQuery(?string $value): void {
        $this->getBackingStore()->set('query', $value);
    }

    /**
     * Sets the urn property value. Uniform resource name (URN) of the automated investigation where the cluster was identified.
     * @param string|null $value Value to set for the urn property.
    */
    public function setUrn(?string $value): void {
        $this->getBackingStore()->set('urn', $value);
    }

}
