--
-- Update Monitors table to have EventCloseMode
--

SELECT 'Checking for EventCloseMode in Monitors';
SET @s = (SELECT IF(
  (SELECT COUNT(*)
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE table_name = 'Monitors'
  AND table_schema = DATABASE()
  AND column_name = 'EventCloseMode'
  ) > 0,
"ALTER TABLE Monitors MODIFY `EventCloseMode`  enum('system', 'time', 'duration', 'idle', 'alarm') NOT NULL DEFAULT 'system'",
"ALTER TABLE Monitors ADD `EventCloseMode`  enum('system', 'time', 'duration', 'idle', 'alarm') NOT NULL DEFAULT 'system' AFTER SectionLengthWarn"
));

PREPARE stmt FROM @s;
EXECUTE stmt;

SET @s = (SELECT IF(
    (SELECT COUNT(*)
      FROM INFORMATION_SCHEMA.TABLES
      WHERE table_name = 'User_View_Permissions'
      AND table_schema = DATABASE()
    ) > 0,
    "SELECT 'User_View_Permissions table exists'",
    "
CREATE TABLE User_View_Permissions (
  Id SERIAL,
  UserId int(10) unsigned,
  View    TEXT,
  Permission  BOOLEAN NOT NULL DEFAULT TRUE,
  PRIMARY KEY (Id)
)
    "
  ));

PREPARE stmt FROM @s;
EXECUTE stmt;

SET @s = (SELECT IF(
  (SELECT COUNT(*)
  FROM INFORMATION_SCHEMA.STATISTICS
  WHERE table_name = 'User_View_Permissions'
  AND table_schema = DATABASE()
  AND index_name = 'User_View_Permissions_UserID_idx'
  ) > 0,
"SELECT 'UserId Index already exists on User_View_Permissions table'",
"CREATE INDEX `User_View_Permissions_UserId_idx` ON `User_View_Permissions` (`UserId`)"
));

PREPARE stmt FROM @s;
EXECUTE stmt;
