package ONVIF::Device::Types::MetadataInput;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %MetadataConfig_of :ATTR(:get<MetadataConfig>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        MetadataConfig
        Extension

    ) ],
    {
        'MetadataConfig' => \%MetadataConfig_of,
        'Extension' => \%Extension_of,
    },
    {
        'MetadataConfig' => 'ONVIF::Device::Types::Config',
        'Extension' => 'ONVIF::Device::Types::MetadataInputExtension',
    },
    {

        'MetadataConfig' => 'MetadataConfig',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::MetadataInput

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
MetadataInput from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * MetadataConfig


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::MetadataInput
   MetadataConfig =>  { # ONVIF::Device::Types::Config
     Parameters =>  { # ONVIF::Device::Types::ItemList
       SimpleItem => ,
       ElementItem =>  {
       },
       Extension =>  { # ONVIF::Device::Types::ItemListExtension
       },
     },
   },
   Extension =>  { # ONVIF::Device::Types::MetadataInputExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

