package ONVIF::Device::Types::AnalyticsDeviceEngineConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %EngineConfiguration_of :ATTR(:get<EngineConfiguration>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        EngineConfiguration
        Extension

    ) ],
    {
        'EngineConfiguration' => \%EngineConfiguration_of,
        'Extension' => \%Extension_of,
    },
    {
        'EngineConfiguration' => 'ONVIF::Device::Types::EngineConfiguration',
        'Extension' => 'ONVIF::Device::Types::AnalyticsDeviceEngineConfigurationExtension',
    },
    {

        'EngineConfiguration' => 'EngineConfiguration',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::AnalyticsDeviceEngineConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AnalyticsDeviceEngineConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * EngineConfiguration


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::AnalyticsDeviceEngineConfiguration
   EngineConfiguration =>  { # ONVIF::Device::Types::EngineConfiguration
     VideoAnalyticsConfiguration =>  { # ONVIF::Device::Types::VideoAnalyticsConfiguration
       AnalyticsEngineConfiguration =>  { # ONVIF::Device::Types::AnalyticsEngineConfiguration
         AnalyticsModule =>  { # ONVIF::Device::Types::Config
           Parameters =>  { # ONVIF::Device::Types::ItemList
             SimpleItem => ,
             ElementItem =>  {
             },
             Extension =>  { # ONVIF::Device::Types::ItemListExtension
             },
           },
         },
         Extension =>  { # ONVIF::Device::Types::AnalyticsEngineConfigurationExtension
         },
       },
       RuleEngineConfiguration =>  { # ONVIF::Device::Types::RuleEngineConfiguration
         Rule =>  { # ONVIF::Device::Types::Config
           Parameters =>  { # ONVIF::Device::Types::ItemList
             SimpleItem => ,
             ElementItem =>  {
             },
             Extension =>  { # ONVIF::Device::Types::ItemListExtension
             },
           },
         },
         Extension =>  { # ONVIF::Device::Types::RuleEngineConfigurationExtension
         },
       },
     },
     AnalyticsEngineInputInfo =>  { # ONVIF::Device::Types::AnalyticsEngineInputInfo
       InputInfo =>  { # ONVIF::Device::Types::Config
         Parameters =>  { # ONVIF::Device::Types::ItemList
           SimpleItem => ,
           ElementItem =>  {
           },
           Extension =>  { # ONVIF::Device::Types::ItemListExtension
           },
         },
       },
       Extension =>  { # ONVIF::Device::Types::AnalyticsEngineInputInfoExtension
       },
     },
   },
   Extension =>  { # ONVIF::Device::Types::AnalyticsDeviceEngineConfigurationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

