package ONVIF::PTZ::Types::Dot11SecurityConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Mode_of :ATTR(:get<Mode>);
my %Algorithm_of :ATTR(:get<Algorithm>);
my %PSK_of :ATTR(:get<PSK>);
my %Dot1X_of :ATTR(:get<Dot1X>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Mode
        Algorithm
        PSK
        Dot1X
        Extension

    ) ],
    {
        'Mode' => \%Mode_of,
        'Algorithm' => \%Algorithm_of,
        'PSK' => \%PSK_of,
        'Dot1X' => \%Dot1X_of,
        'Extension' => \%Extension_of,
    },
    {
        'Mode' => 'ONVIF::PTZ::Types::Dot11SecurityMode',
        'Algorithm' => 'ONVIF::PTZ::Types::Dot11Cipher',
        'PSK' => 'ONVIF::PTZ::Types::Dot11PSKSet',
        'Dot1X' => 'ONVIF::PTZ::Types::ReferenceToken',
        'Extension' => 'ONVIF::PTZ::Types::Dot11SecurityConfigurationExtension',
    },
    {

        'Mode' => 'Mode',
        'Algorithm' => 'Algorithm',
        'PSK' => 'PSK',
        'Dot1X' => 'Dot1X',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::Dot11SecurityConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Dot11SecurityConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Mode


=item * Algorithm


=item * PSK


=item * Dot1X


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::Dot11SecurityConfiguration
   Mode => $some_value, # Dot11SecurityMode
   Algorithm => $some_value, # Dot11Cipher
   PSK =>  { # ONVIF::PTZ::Types::Dot11PSKSet
     Key => $some_value, # Dot11PSK
     Passphrase => $some_value, # Dot11PSKPassphrase
     Extension =>  { # ONVIF::PTZ::Types::Dot11PSKSetExtension
     },
   },
   Dot1X => $some_value, # ReferenceToken
   Extension =>  { # ONVIF::PTZ::Types::Dot11SecurityConfigurationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

